package w83b.w83bDAO;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang.StringUtils;

import w83b.util.jdbc.W83bDataBase;
import w83b.w83bBeans.W83bActasBean;
import w83b.w83bBeans.W83bDelegadoPrevencionBean;
import w83b.w83bBeans.W83bDelegadosBean;
import w83b.w83bDAO.w83bConstantesBD.W83bDelegadosPrevencionBD;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import w83b.w83bUtilidadesComunes.W83bDateUtil;


public class W83bDelegadosPrevencionDAO implements W83bIDelegadosPrevencionDAO {
	
	/**
	 * Obtiene el delegado de prevencin de un acta
	 * @param acta W83bActasBean
	 * @param dniDelegado String
	 * @return W83bDelegadoPrevencionBean
	 * @throws Exception exception
	 */
	public W83bDelegadoPrevencionBean obtenerDelegadoPrevencionActa(W83bActasBean acta, String dniDelegado) throws Exception {
		
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT ");
		strSql.append(W83bDelegadosPrevencionBD.PROV).append(",");
		strSql.append(W83bDelegadosPrevencionBD.NACTA).append(",");
		strSql.append(W83bDelegadosPrevencionBD.CDNI).append(",");
		strSql.append(W83bDelegadosPrevencionBD.NOMB).append(",");
		strSql.append(W83bDelegadosPrevencionBD.APE1).append(",");
		strSql.append(W83bDelegadosPrevencionBD.APE2).append(",");
		strSql.append(W83bDelegadosPrevencionBD.CSINDI).append(",");
		strSql.append(W83bDelegadosPrevencionBD.FALTA).append(",");
		strSql.append(W83bDelegadosPrevencionBD.FBAJA).append(",");
		strSql.append(W83bDelegadosPrevencionBD.USUA).append(",");
		strSql.append(W83bDelegadosPrevencionBD.FACTU).append(",");
		strSql.append(W83bDelegadosPrevencionBD.ANO).append(",");
		strSql.append(W83bDelegadosPrevencionBD.SEXO);

		strSql.append(" FROM ").append(W83bDelegadosPrevencionBD.tabla);
		strSql.append(" WHERE ").append(W83bDelegadosPrevencionBD.FBAJA).append(" IS NULL");
		strSql.append(" AND ").append(W83bDelegadosPrevencionBD.PROV).append(" = ?");
		strSql.append(" AND ").append(W83bDelegadosPrevencionBD.NACTA).append(" = ?");
		strSql.append(" AND ").append(W83bDelegadosPrevencionBD.ANO).append(" = ?");
		params.add(acta.getNumActaTerritorio());	
		params.add(acta.getNumActa());
		params.add(acta.getNumActaAno());
		if(dniDelegado!=null){
			strSql.append(" AND ").append(W83bDelegadosPrevencionBD.CDNI).append(" = ?");
			params.add(dniDelegado);
		}
		
		
		List listaDocumentos = W83bDataBase.executeQuery(strSql.toString(),params,W83bDelegadoPrevencionBean.class,null, null);
		
		if (listaDocumentos.size()>0)
			return (W83bDelegadoPrevencionBean)listaDocumentos.get(0);
		else
			return null;
	}
	
	
	/**
	 * Da de baja un delegado de prevencin
	 * @param acta W83bActasBean
	 * @param dniDelegado String
	 * @param fechaBaja String
	 * @throws Exception exception
	 */
	public void updateBajaDelegadoPrevencion(W83bActasBean acta, String dniDelegado, String fechaBaja) throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		
		params= new ArrayList();
		strSql.append("UPDATE ");
		strSql.append(W83bDelegadosPrevencionBD.tabla);
		strSql.append (" SET ");
		
		strSql.append(W83bDelegadosPrevencionBD.FBAJA);
		
		if(W83bClsConstantes.CONSTANTE_CASTELLANO.equals(acta.getIdioma())){
			strSql.append(" = to_date(?,'"+W83bDateUtil.ES_PATTERN+"')");
		}else{
			strSql.append(" = to_date(?,'"+W83bDateUtil.EU_PATTERN+"')");		
		}
		
		strSql.append(", ");
		strSql.append(W83bDelegadosPrevencionBD.FACTU);
		strSql.append(" = SYSDATE ");
		strSql.append(" WHERE ").append(W83bDelegadosPrevencionBD.PROV).append(" = ?");
		strSql.append(" AND ").append(W83bDelegadosPrevencionBD.NACTA).append(" = ?");
		strSql.append(" AND ").append(W83bDelegadosPrevencionBD.ANO).append(" = ?");
		strSql.append(" AND ").append(W83bDelegadosPrevencionBD.CDNI).append(" = ?");
		
		params.add(fechaBaja);
		params.add(acta.getNumActaTerritorio());	
		params.add(acta.getNumActa());
		params.add(acta.getNumActaAno());
		params.add(dniDelegado);
		
		W83bDataBase.executeTableMovement(strSql.toString(), params, acta.getUsuarioBean());		
	}
	
	
	/**
	 * Aade un delegado de prevencin para un acta
	 *
	 * @param delegado W83bDelegadosBean
	 * @throws Exception the exception
	 */
	public void insertDelegadoPrevencion(W83bDelegadosBean delegado)throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("INSERT INTO ");
		strSql.append(W83bDelegadosPrevencionBD.tabla);
		strSql.append("(");
		strSql.append(W83bDelegadosPrevencionBD.PROV);
		strSql.append(", ");
		strSql.append(W83bDelegadosPrevencionBD.ANO);
		strSql.append(", ");
		strSql.append(W83bDelegadosPrevencionBD.NACTA);
		strSql.append(", ");
		strSql.append(W83bDelegadosPrevencionBD.CDNI);
		strSql.append(", ");
		strSql.append(W83bDelegadosPrevencionBD.NOMB);
		strSql.append(", ");
		strSql.append(W83bDelegadosPrevencionBD.APE1);
		strSql.append(", ");
		strSql.append(W83bDelegadosPrevencionBD.APE2);
		strSql.append(", ");
		strSql.append(W83bDelegadosPrevencionBD.CSINDI);
		strSql.append(", ");
		strSql.append(W83bDelegadosPrevencionBD.FALTA);
		strSql.append(", ");
		strSql.append(W83bDelegadosPrevencionBD.FBAJA);
		strSql.append(", ");
		strSql.append(W83bDelegadosPrevencionBD.USUA);
		strSql.append(", ");
		strSql.append(W83bDelegadosPrevencionBD.FACTU);
		strSql.append(", ");
		strSql.append(W83bDelegadosPrevencionBD.SEXO);
		strSql.append(")");
		strSql.append(" VALUES (?,?,?,?,?,?,?,?,");
		if(StringUtils.isNotEmpty(delegado.getFechaAlta())){
			strSql.append("to_date(?,?)");
		}else{
			strSql.append("?");			
		}
		strSql.append(",?,?, SYSDATE,?)");
		
		params.add(delegado.getActaTerritorio());
		params.add((delegado.getActaAnyo()!=null)? Integer.valueOf(delegado.getActaAnyo()):null);
		params.add((delegado.getActaNum()!=null)? Integer.valueOf(delegado.getActaNum()):null);
		params.add(delegado.getDniDelegado());
		params.add(delegado.getNombreDelegado());
		params.add(delegado.getPrimerApellidoDelegado());
		params.add(delegado.getSegundoApellidoDelegado());
		params.add((delegado.getCodSindicato()!=null)? Integer.valueOf(delegado.getCodSindicato()):null);
		if(StringUtils.isNotEmpty(delegado.getFechaAlta())){
			params.add(delegado.getFechaAlta());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(delegado.getIdioma()));
		}
		else{
			params.add(W83bClsConstantes.NULL_DATE);
		}
		params.add(W83bClsConstantes.NULL_DATE);
		params.add(delegado.getUsuario());
		params.add(delegado.getSexoDelegado());

		W83bDataBase.executeTableMovement(strSql.toString(), params,delegado.getUsuarioBean());
	}
	
}
